//
//  GHAccelerometerData.h
//  Garmin Health
//
//  Created by Echeandia, Augie on 9/5/17.
//  Copyright © 2017 Garmin International, Inc. or its affiliates. All rights reserved.
//

#import <Foundation/Foundation.h>

/**
 *  The GHAccelerometerData class provides the accelerometer sample data that was extracted from the Garmin device.
 */
@interface GHAccelerometerData : NSObject <NSCoding>

/**
 *  Timestamp for the associated accelerometer data.
 *  @note Can be null.
 */
@property (nullable, nonatomic) NSDate *timestamp;

/**
 *  Milliseconds portion of the timestamp for the associated accelerometer data.
 *  @note Can be null.
 */
@property (nullable, nonatomic) NSNumber *milliseconds;

/**
 *  Timestamp using a 32Hz clock associated accelerometer data. This value
 *  This value rolls over every 32768 seconds.
 *  @note Can be null.
 */
@property (nullable, nonatomic) NSNumber *timestamp32K;

/**
 *  X coordinate value.
 *  @note Can be null.
 */
@property (nullable, nonatomic) NSNumber *xValue;

/**
 *  Y coordinate value.
 *  @note Can be null.
 */
@property (nullable, nonatomic) NSNumber *yValue;

/**
 *  Z coordinate value.
 *  @note Can be null.
 */
@property (nullable, nonatomic) NSNumber *zValue;


@end
